package GUI;


import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import baseClass.*;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/**
 * @author Carlos Victor 
 */
public class JanelaRecomendacoes implements MouseListener, ActionListener {

	private JFrame window = null;
	private JPanel panel1 = null;
	private JButton button1,button2,button3= null;
	private JLabel label1,label2,label3,label4 = null;
	private JComboBox comboBox = null;
	private Recomendacoes recomendacoes = null;
	private JTextArea txt = null;
	private JTextField num = null;
	private Component comp = null; 
	private JLabel label6 = null;
	private JComboBox comboBox2 = null;
	  
	/**
	 * Cria uma nova janela de sistema de recomendacoes
	 * @param opinioes
	 * 		O caminho do arquivo de opinioes.
	 * @param enderecos
	 * 		O caminho do arquivo de enderecos.
	 */
	public JanelaRecomendacoes(Recomendacoes recomendacoes) {
		
		this.recomendacoes = recomendacoes;
		
		createWindow();
	}
	

	/**
	 * Criacao da janela.
	 */
	private void createWindow() {
		window = new JFrame();
		panel1 = new JPanel();
		button1 = new JButton("Ok");
		button2 = new JButton("Voltar");
		button3 = new JButton("Ajuda");
		num = new JTextField(10);
		label1 = new JLabel("SEJA BEM VINDO AO SISTEMA DE RECOMEDAÇÕES.");
		label2 = new JLabel("DIGITE O NÚMERO DE RECOMENDAÇÕES");
		label3 = new JLabel("USUÁRIOS");
		label4 = new JLabel("TIPO DE RECOMENDAÇÕES");
		label6 = new JLabel(); 
		comboBox = new JComboBox();
		comboBox2 = new JComboBox();
		txt = new JTextArea();
		comp = new JScrollPane(txt); 
			
		window.setSize(700, 600);
		window.setResizable(true);
		window.setMinimumSize(new Dimension(300, 200));
		window.setLocation(280, 60);
		window.setVisible(true);
		window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		label6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/image3101-v3.png")));
		label6.setLocation(0, -150);
		label6.setSize(550,470);
		label1.setLocation(340, -100);
		label1.setSize(300, 300);
		label1.setForeground(Color.WHITE);
		label2.setLocation(50, 330);
		label2.setSize(300, 300);
		label2.setForeground(Color.WHITE);
		label3.setLocation(100, 80);
		label3.setSize(300, 300);
		label3.setForeground(Color.WHITE);
		label4.setLocation(440, 80);
		label4.setSize(300, 300);
		label4.setForeground(Color.WHITE);
		
		
		panel1.setVisible(true);
		panel1.setLayout(null);
		panel1.setBackground(Color.ORANGE);
		
		button1.setToolTipText("Carrega recomendações");
		button1.setEnabled(true);
		button1.addMouseListener(this);
		button1.addActionListener(this);
		button1.setLocation(100,380);
		button1.setSize(100,20);
		button1.setForeground(Color.ORANGE);
		button2.setToolTipText("Voltar ao menu principal");
		button2.setEnabled(true);
		button2.addMouseListener(this);
		button2.addActionListener(this);
		button2.setSize(100,20);
		button2.setLocation(100, 420);
		button2.setForeground(Color.ORANGE);
		button3.setToolTipText("Tutorial sobre o sistema.");
		button3.setEnabled(true);
		button3.addMouseListener(this);
		button3.addActionListener(this);
		button3.setSize(100,20);
		button3.setLocation(434, 90);
		button3.setForeground(Color.ORANGE);
		
		num.setLocation(120, 500);
		num.setSize(60, 30);
		
		comp.setSize(300, 200);
		comp.setLocation(300, 350);
		txt.setEnabled(false);
		
		comboBox.setToolTipText("Tipos de recomendações");
		comboBox.addItem("Recomendações por popularidade");
		comboBox.addItem("Recomendações Global");
		comboBox.addItem("Recomendações Personalizada");
		comboBox.setLocation(410, 250);
		comboBox.setSize(230, 20);
		comboBox.setForeground(Color.ORANGE);
		
		for (User user : recomendacoes.getUsuarios()) {
			comboBox2.addItem(user.getNome());
		}
		
		comboBox2.setLocation(30, 250);
		comboBox2.setSize(200, 20);
		comboBox2.setForeground(Color.ORANGE);
		
		panel1.add(label1);
		panel1.add(num);
		panel1.add(label2);
		panel1.add(label3);
		panel1.add(label4);
		panel1.add(button1);
		panel1.add(button2);
		panel1.add(button3);
		panel1.add(comboBox);
		panel1.add(comboBox2);
		panel1.add(label6);
		panel1.add(comp);
		window.add(panel1);
	}

	/**
	 * M�todos referentes ao MouseListenner
	 */
	public void mouseClicked(MouseEvent arg0) {
	}
	
	public void mouseEntered(MouseEvent arg0) {
	}
	
	public void mouseExited(MouseEvent arg0) {
	}

	public void mousePressed(MouseEvent arg0) {
	}

	public void mouseReleased(MouseEvent arg0) {
	}

	/**
	 * Metodo referente ao ActionListener
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == button1) {
			txt.setText("");
			User usuario = null;
			for (User user : recomendacoes.getUsuarios()) {
				if (user.getNome().equals(comboBox2.getSelectedItem())) {
					usuario = user;
				}
			}
			
			if (comboBox.getSelectedItem().equals("Recomendações por popularidade")) {
				
				for (String res : recomendacoes.getRestaurantes()) {
					txt.append(res+"\n");
				}
				
			}
			
			if (comboBox.getSelectedItem().equals("Recomendações Global")) {
				
				int numItens = 1;
				if (num.getText().isEmpty()) {
					JOptionPane.showMessageDialog(null, "Digite o número de recomendações");
				}else{
					try{
						numItens = Integer.parseInt(num.getText());
						
						if (numItens < 1) {
							numItens = 1;
						}
						try {
							for (String res : recomendacoes.popularidadeGlobal(numItens)) {
								txt.append(res + "\n");
							}
						} catch (Exception e1) {
							JOptionPane.showMessageDialog(null, "Número de estabelecimentos ultrapassado.");
						}
					}catch (Exception ex){
						JOptionPane.showMessageDialog(null, "Digite apenas números");
					}
					
				}
				
			}
			
			if (comboBox.getSelectedItem().equals("Recomendações Personalizada")) {
				
				int numItens = 1;
				if (num.getText().isEmpty()) {
					JOptionPane.showMessageDialog(null, "Digite o número de recomendações");
				}else{
					try{
						numItens = Integer.parseInt(num.getText());
						
						
						if (numItens < 1) {
							numItens = 1;
						}
						try {
							if (recomendacoes.PopularidadePersonalizada(usuario, numItens).isEmpty()) {
								txt.append("Não existem recomendações disponíveis para este usuário,\npois o mesmo conhece todos os estabelcimentos!");
							}else{
								for (String res : recomendacoes.PopularidadePersonalizada(usuario, numItens)) {
									txt.append(res + "\n");
								}
							}
							
						} catch (Exception e1) {
							JOptionPane.showMessageDialog(null, "Número de recomendações para esse usuário ultrapassado");
						}
					}catch (Exception ex){
						JOptionPane.showMessageDialog(null, "Digite apenas números");
					}
					
				}
			}
		
				
				
	}
		if (e.getSource() == button2) {
			window.dispose();
			new MenuRecomendacoes(recomendacoes.getCaminhoArquivo2(), recomendacoes.getCaminhoArquivo1());
		}
		
		if (e.getSource() == button3) {
			JOptionPane.showMessageDialog(null, "SISTEMA DE RECOMENDAÇÕES\nVOCÊ DEVE ESOLHER UM TIPO DE RECOMENDAÇÃO PODENDO OPTAR ENTRE\nPERSONALIZADO, GLOBAL E POPULAR. O SISTEMA PERSONALIZADO E O GLOBAL NECESSITAM QUE O USUÁRIO DIGITE O NÚMERO\nDE ITENS DESEJADOS, APÓS SEGUIR OS PASSOS CORRETAMENTE DEVE-SE PRESSIONAR OK PARA GERAR AS RECOMENDAÇÕES,\nOU PRESSIONAR VOLTAR PARA RETORNAR AO MENU ANTERIOR.");
		}
		

	
	}
}
